package img;

import java.awt.Color;

/**
 * Transformation : redimensionnement de l'image sans interpolation.
 * <p>
 * 
 * Le redimensionnement est rudimentaire. Il est fondé sur l'échantillonnage et
 * la duplication des pixels. Aucune valeur de pixel n'est calculée (pas
 * d'interpolation).
 * 
 */
public class Dimensions extends Transformation {

	/**
	 * Nouvelle largeur de l'image (nombre de pixels).
	 */
	protected int largeur;

	/**
	 * Nouvelle hauteur de l'image (nombre de pixels).
	 */
	protected int hauteur;

	/**
	 * Constructeur : initialise les nouvelles dimensions
	 * 
	 * @param largeur nouvelle largeur de l'image (nombre de pixels)
	 * @param hauteur nouvelle hauteur de l'image (nombre de pixels)
	 */
	public Dimensions(int largeur, int hauteur) {
		this.largeur = largeur;
		this.hauteur = hauteur;
	}

	/**
	 * Redimensionne l'image.
	 * <p>
	 * Le nouveau tableau renvoyé en résultat ne contient que les valeurs des pixels
	 * d'origine (pas d'interpolation). Une dimension réduite implique
	 * d'échantillonner les pixels. Une dimension agrandie implique de dupliquer les
	 * pixels.
	 * 
	 * @param pixels tableau source
	 * @return nouveau tableau correspondant au redimensionnement de l'image
	 */
	@Override
	protected Color[][] transforme(Color[][] pixels) {
		// TODO EXERCICE 2 : à compléter...
		return null; // <- TODO résultat à adapter
	}

}
